#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Space PolypMod01.fsh   by   OliverSchaff 
//https://www.shadertoy.com/view/tdSXWt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Renderingcode from a shader by Shane
// https://www.shadertoy.com/view/ll2SRy

#define PI 3.14159265359
#define grad_step 0.01
#define time 2.0*iTime


// Spectrum colour palette
// IQ https://www.shadertoy.com/view/ll2GD3
vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d ) {
    return a + b*cos( 6.28318*(c*t+d) );
}

vec3 spectrum(float n) {
    return pal( n, vec3(0.5,0.5,0.5),vec3(0.0,0.5,0.5),vec3(.0,1.0,.0),vec3(0.62,0.33,0.37) );
}

// iq's distance functions
float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float opOnion( in float sdf, in float thickness )
{
    return abs(sdf)-thickness;
}

float sdUnion_s( float a, float b, float k ) {
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

vec3 carToPol(vec3 p) {
    float r = length(p);
    float the = acos(p.z/r);
    float phi = atan(p.y,p.x);
    return vec3(r,the,phi);
}

// 2D rotation : pitch, yaw
mat3 rotationXY( vec2 angle ) {
	vec2 c = cos( angle );
	vec2 s = sin( angle );
	
	return mat3(
		c.y      ,  0.0, -s.y,
		s.y * s.x,  c.x,  c.y * s.x,
		s.y * c.x, -s.x,  c.y * c.x
	);
}

float pModPolar(inout vec2 p, float repetitions) { 
	float angle = 2.*PI/repetitions; 
	float a = atan(p.y, p.x) + angle/2.; 
	float r = length(p); 
	float c = floor(a/angle); 
	a = mod(a,angle) - angle/2.; 
	p = vec2(cos(a), sin(a))*r; 
    // For an odd number of repetitions, fix cell index of the cell in -x direction // (cell index would be e.g. -5 and 5 in the two halves of the cell): 
	if (abs(c) >= (repetitions/2.)) c = abs(c); 
    return c;
}


float sdVerticalCapsule( vec3 p, float h, float r )
{
    p.z -= clamp( p.z, 0.0, h );
    return length( p ) - r;
}

float distortedCapsule(vec3 p){
    float dtime = 1.8*p.z-time-1.; // mix time with space to create wave
    float dt = sin((dtime)-0.8*sin(dtime)); // distorted time, asymmetric sine wave
    p.x += 0.2*(p.z)*dt;
   	float d = sdVerticalCapsule(p-vec3(0.9,0,0.), 2.0,0.05*(4.0-1.5*p.z));
    float d2 = sdSphere(p-vec3(0.9,0,2.0),0.2);
    d = sdUnion_s(d,d2,0.1);
	return d;
}



float map( vec3 p ){
    float dt = sin((time+2.5)-0.8*sin(time+2.5)); // distorted time, asymmetric sine wave
    p.z += -0.2*dt;
    float d0 = sdSphere(p-vec3(0,0,-0.7),0.5);
    
    float tentacleIndex = pModPolar(p.xy, 9.0);
    p = rotationXY(vec2(0.0,-0.8))*p;
    float d2 = distortedCapsule(p);
    d0 = sdUnion_s(d0,d2,0.4);
    return d0;
}

// get gradient in the world
vec3 gradient( vec3 pos ) {
	const vec3 dx = vec3( grad_step, 0.0, 0.0 );
	const vec3 dy = vec3( 0.0, grad_step, 0.0 );
	const vec3 dz = vec3( 0.0, 0.0, grad_step );
	return normalize (
		vec3(
			map( pos + dx ) - map( pos - dx ),
			map( pos + dy ) - map( pos - dy ),
			map( pos + dz ) - map( pos - dz )			
		)
	);
}


vec3 fresnel( vec3 F0, vec3 h, vec3 l ) {
	return F0 + ( 1.0 - F0 ) * pow( clamp( 1.0 - dot( h, l ), 0.0, 1.0 ), 5.0 );
}



vec3 selfColor(vec3 pos) {
    vec3 pol = carToPol(pos-vec3(0,0,-0.8));
    return spectrum(0.45*pol.x);
}

mat3 calcLookAtMatrix( in vec3 ro, in vec3 ta, in float roll )
{
    vec3 ww = normalize( ta - ro );
    vec3 uu = normalize( cross(ww,vec3(sin(roll),cos(roll),0.0) ) );
    vec3 vv = normalize( cross(uu,ww));
    return mat3( uu, vv, ww );
}

vec3 reflectedColor(in vec3 p, in vec3 rd){
    
    vec3 Ks = vec3(0.7); // specular reflected intensity
    float shininess = 40.0;
    
   	vec3 n = gradient( p );
    vec3 ref = reflect( rd, n );
    vec3 rc = vec3(0);
    
    vec3 light_pos   = vec3( 15.0, 20.0, 5.0 );
	vec3 light_color = vec3( 1.0, 1.0, 1.0 );
	vec3 vl = normalize( light_pos - p );
	vec3 specular = vec3( max( 0.0, dot( vl, ref ) ) );
    vec3 F = fresnel( Ks, normalize( vl - rd ), vl );
	specular = pow( specular, vec3( shininess ) );
	rc += light_color * specular; 
    return rc;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    vec2 p = (-iResolution.xy + 2.0*fragCoord.xy)/iResolution.y;
    vec3 ro = vec3( 5.0*cos(0.2*iTime-10.0), 1.0, 5.0*sin(0.2*iTime-10.0));
    vec3 ta = vec3( 0. , 0. , 0. );
    
    float aa = 1.0/min(iResolution.y,iResolution.x);
    
    // camera matrix
    mat3 camMat = calcLookAtMatrix( ro, ta, 0.0);  // 0.0 is the camera roll
    
	// create view ray
	vec3 rd = normalize( camMat * vec3(p.xy, 1.9+0.8*sin(0.15*iTime+12.0)) ); // 3.0 is the lens length
    
    // rotate camera with mouse
	mat3 rot = rotationXY(iMouse.xy * vec2( 0.01, -0.01 ) );
	rd = rot * rd;
	ro = rot * ro;
    vec3 col = vec3(0), sp;
    
	// Ray distance, bail out layer number, surface distance and normalized accumulated distance.
	float t=0., layers=0., d, aD;
    
    // Surface distance threshold. Smaller numbers give a sharper object. Antialiased with aa
    float thD = 0.5*sqrt(aa); 
    
    // Only a few iterations seemed to be enough. Obviously, more looks better, but is slower.
	for(int i=0; i<50; i++)	{
        
        // Break conditions. Anything that can help you bail early usually increases frame rate.
        if(layers>12. || col.g>1.0 || t>8.) break;
        
        // Current ray postion
        sp = ro + rd*t;
		
        d = map(sp); // Distance to nearest point in the cube field.
        
        // If we get within a certain distance of the surface, accumulate some surface values.
        // Values further away have less influence on the total.
        //
        // aD - Accumulated distance. I interpolated aD on a whim (see below), because it seemed 
        // to look nicer.
        //
        // 1/.(1. + t*t*.85) - Basic distance attenuation. Feel free to substitute your own.
        
         // Normalized distance from the surface threshold value to our current isosurface value.
        aD = (thD-abs(d))/thD;
        
        // If we're within the surface threshold, accumulate some color.
        // Two "if" statements in a shader loop makes me nervous. I don't suspect there'll be any
        // problems, but if there are, let us know.
        if(aD>0.) { 
            // Smoothly interpolate the accumulated surface distance value, then apply some
            // basic falloff (fog, if you prefer) using the camera to surface distance, "t."
            // selfColor is the color of the object at the point sp
            vec3 sc = selfColor(sp);
            col += 8.*sc*(aD*aD*(3. - 2.*aD)/(1. + t*t*0.85));
            col += 1.0*reflectedColor(sp, rd);
            layers++;
        }

		
        // Kind of weird the way this works. I think not allowing the ray to hone in properly is
        // the very thing that gives an even spread of values. The figures are based on a bit of 
        // knowledge versus trial and error. If you have a faster computer, feel free to tweak
        // them a bit.
        //t += abs(d)*0.5;
        t += max(abs(d)*0.8, thD*1.1); 
	}
    
    // I'm virtually positive "col" doesn't drop below zero, but just to be safe...
    col = max(col, 0.);
    
	fragColor = vec4(clamp(col, 0., 1.), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

